Imports Microsoft.VisualBasic
Imports System.Net.Mail
Imports System.Web.Configuration
Imports System.Configuration
Imports System.Net.Mail.SmtpClient


Public Class Utilities


    ''' <summary>
    ''' MailSettings jest struktur zawierajc informacje o serwerze poczty
    ''' </summary>
    Public Structure MailSettings
        Public MailServer As String
        Public MailPort As Integer
        Public MailFrom As String
        Public MailUser As String
        Public MailPassword As String
    End Structure

    ''' <summary>
    ''' GetSmtpSettings pobiera wartoci z pliku web.config i przypisuje je do waciwoci egzemplarza struktury
    ''' </summary>
    Private Shared Function GetSmtpSettings() As MailSettings

        Dim SmtpSettings As MailSettings
        SmtpSettings.MailServer = WebConfigurationManager.AppSettings("SmtpServer")
        SmtpSettings.MailFrom = WebConfigurationManager.AppSettings("EmailFrom")
        SmtpSettings.MailPort = CInt(WebConfigurationManager.AppSettings("MailPort"))
        SmtpSettings.MailUser = WebConfigurationManager.AppSettings("MailUser")
        SmtpSettings.MailPassword = WebConfigurationManager.AppSettings("MailPassword")
        Return SmtpSettings

    End Function

    ''' <summary>
    ''' GetCredentials ustawia wartoci uwierzytelnienia dla potrzeb serwera poczty
    ''' </summary>
    Private Shared Function GetCredentials(ByVal SmtpSettings As MailSettings) As System.Net.NetworkCredential
        Dim Wuser As String = SmtpSettings.MailUser
        Dim Wpassword As String = SmtpSettings.MailPassword
        Dim myCredentials As New System.Net.NetworkCredential(Wuser, Wpassword)
        Return myCredentials
    End Function

    ''' <summary>
    ''' SendEmail wysya e-mail o ustalonych ustawieniach i parametrach 
    ''' </summary>
    Public Shared Sub SendEmail(ByVal MsgTo As String, ByVal MsgFrom As String, ByVal MsgSubject As String, ByVal MsgText As String)

        Dim SmtpSettings As MailSettings
        SmtpSettings = GetSmtpSettings()
        Dim SmptCl As New SmtpClient(SmtpSettings.MailServer, SmtpSettings.MailPort)
        SmptCl.Credentials = GetCredentials(SmtpSettings)
        Dim MailMsg As New MailMessage(MsgFrom, MsgTo)
        MailMsg.Subject = MsgSubject
        MailMsg.Body = MsgText

        SmptCl.Send(MailMsg)

    End Sub

End Class

